/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

final class GLLibPlayer
implements Runnable {
    int posX = 0;
    int posY = 0;
    int curFlags = 0;
    ASprite sprite = null;
    private int curAnim = -1;
    private int curFrame = 0;
    private int curTime = 0;
    private int nbLoop = 1;
    private boolean animIsOver = true;
    private int curBlend = -1;
    private int curScale = -1;
    private static int k_animBaseFrameTime = 62;
    private static boolean s_bTilesetPlayerInitialized = false;
    private static int s_TilesetMaxLayerCount = 5;
    private static int s_TilesetEffectLayer = -1;
    private static int s_TilesetAlphaLayer = -1;
    private static int s_TilesetEffectType = 0;
    private static int[] s_TilesetInfo;
    private static int[][] s_TilesetLayerInfo;
    private static byte[][][] s_TilesetLayerData;
    private static Image[][] s_TilesetLayerImage;
    private static Graphics[][] s_TilesetLayerGraphics;
    private static ASprite[] s_TilesetSprite;

    GLLibPlayer() {
    }

    final void SetPos(int n, int n2) {
        this.posX = n;
        this.posY = n2;
    }

    final ASprite GetSprite() {
        return this.sprite;
    }

    final void SetSprite(ASprite aSprite) {
        this.sprite = aSprite;
        this.SetAnim(-1, -1);
    }

    final void SetAnim(int n, int n2, boolean bl) {
        if (bl) {
            this.SetAnim(-1, 1);
        }
        this.SetAnim(n, n2);
    }

    final void SetAnim(int n, int n2) {
        if (this.animIsOver || n != this.curAnim) {
            int n3;
            this.curAnim = n;
            GLLibPlayer gLLibPlayer = this;
            if (gLLibPlayer.curAnim < 0) {
                n3 = -1;
            } else {
                int n4;
                int n5 = gLLibPlayer.GetNbFrame();
                for (n4 = 0; n4 > n5; n4 -= n5) {
                }
                gLLibPlayer.curFrame = n4;
                gLLibPlayer.curTime = 0;
                n3 = n4;
            }
            this.nbLoop = n2 - 1;
            this.animIsOver = false;
        }
    }

    final int GetAnim() {
        return this.curAnim;
    }

    final int GetFrame() {
        return this.curFrame;
    }

    final int GetNbFrame() {
        if (this.curAnim >= 0) {
            return this.sprite.GetAFrames(this.curAnim);
        }
        return -1;
    }

    final boolean IsAnimOver() {
        if (this.curAnim < 0) {
            return true;
        }
        if (this.nbLoop < 0) {
            return false;
        }
        return this.animIsOver;
    }

    final void Render() {
        if (this.curAnim < 0) {
            return;
        }
        if (this.curScale != -1) {
            int n;
            GLLib.PFX_EnableEffect(11, false);
            null[1] = n = this.curScale;
            if (this.curBlend != -1) {
                null[2] = n = this.curBlend;
            }
        } else if (this.curBlend != -1) {
            int n;
            GLLib.PFX_EnableEffect(10, false);
            null[1] = n = this.curBlend;
        }
        this.sprite.PaintAFrame(GLLib.g, this.curAnim, this.curFrame, this.posX, this.posY, 0, 0, 0);
        GLLib.s_PFX_type &= 0xFFFFF21F;
    }

    final void RenderShop() {
        if (this.curAnim < 0) {
            return;
        }
        if (this.curScale != -1) {
            int n;
            GLLib.PFX_EnableEffect(11, false);
            null[1] = n = this.curScale;
            if (this.curBlend != -1) {
                null[2] = n = this.curBlend;
            }
        } else if (this.curBlend != -1) {
            int n;
            GLLib.PFX_EnableEffect(10, false);
            null[1] = n = this.curBlend;
        }
        this.sprite.PaintAFrame(GLLib.g, this.curAnim, this.curFrame, this.posX, this.posY - 10, 0, 0, 0);
        GLLib.s_PFX_type &= 0xFFFFF21F;
    }

    final void Update(int n) {
        if (this.animIsOver || this.curAnim < 0) {
            return;
        }
        GLLibPlayer gLLibPlayer = this;
        int n2 = gLLibPlayer.curAnim >= 0 ? gLLibPlayer.sprite.GetAFrameTime(gLLibPlayer.curAnim, gLLibPlayer.curFrame) * k_animBaseFrameTime : 0;
        if (n2 == 0) {
            new StringBuffer().append("GLLibPlayer.Update.frame ").append(this.curFrame).append(" of animation ").append(this.curAnim).append(" has a duration of 0");
        }
        if (this.curTime >= n2) {
            this.curTime -= n2;
            if (this.curFrame < this.sprite.GetAFrames(this.curAnim) - 1) {
                ++this.curFrame;
            } else if (this.nbLoop == 0) {
                this.animIsOver = true;
            } else {
                if (this.nbLoop > 0) {
                    --this.nbLoop;
                }
                this.curFrame = 0;
            }
        }
        this.curTime += n;
    }

    final void SetBlend(int n) {
        this.curBlend = n;
    }

    public final void run() {
    }

    static void Tileset_Init(int n, int n2, int n3, int n4) {
        s_TilesetInfo = new int[8];
        s_TilesetLayerInfo = new int[s_TilesetMaxLayerCount][15];
        s_TilesetLayerData = new byte[s_TilesetMaxLayerCount][2][];
        s_TilesetLayerImage = new Image[s_TilesetMaxLayerCount][1];
        s_TilesetLayerGraphics = new Graphics[s_TilesetMaxLayerCount][1];
        s_TilesetSprite = new ASprite[s_TilesetMaxLayerCount];
        GLLibPlayer.s_TilesetInfo[0] = n;
        GLLibPlayer.s_TilesetInfo[1] = 299;
        n3 = GLLib.Math_Log2(16);
        n4 = GLLib.Math_Log2(16);
        if (1 << n3 != 16) {
            new StringBuffer().append("Tileset_Init. using GLLibConfig.tileset_UseTileShift with non power of 2 tile width").append(n3);
        }
        if (1 << n4 != 16) {
            new StringBuffer().append("Tileset_Init. using GLLibConfig.tileset_UseTileShift with non power of 2 tile height").append(n4);
        }
        GLLibPlayer.s_TilesetInfo[3] = n3;
        GLLibPlayer.s_TilesetInfo[2] = 1 << n3;
        GLLibPlayer.s_TilesetInfo[4] = s_TilesetInfo[2] - 1;
        GLLibPlayer.s_TilesetInfo[6] = n4;
        GLLibPlayer.s_TilesetInfo[5] = 1 << n4;
        GLLibPlayer.s_TilesetInfo[7] = s_TilesetInfo[5] - 1;
        s_bTilesetPlayerInitialized = true;
    }

    private static final boolean isFlag(int n, int n2) {
        return (s_TilesetLayerInfo[n][14] & n2) != 0;
    }

    private static final void setFlag(int n, int n2, boolean bl) {
        if (bl) {
            int[] nArray = s_TilesetLayerInfo[n];
            nArray[14] = nArray[14] | n2;
            return;
        }
        int[] nArray = s_TilesetLayerInfo[n];
        nArray[14] = nArray[14] & ~n2;
    }

    static void Tileset_LoadLayer(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, ASprite aSprite, int n2, int n3, int n4, int n5) {
        if (!s_bTilesetPlayerInitialized) {
            return;
        }
        GLLibPlayer.Tileset_Destroy(n, false);
        GLLibPlayer.s_TilesetLayerData[n][0] = byArray2;
        GLLibPlayer.s_TilesetLayerData[n][1] = byArray3;
        GLLibPlayer.s_TilesetLayerInfo[n][2] = GLLib.Mem_GetShort(byArray, 0);
        GLLibPlayer.s_TilesetLayerInfo[n][3] = GLLib.Mem_GetShort(byArray, 2);
        GLLibPlayer.s_TilesetLayerInfo[n][4] = s_TilesetLayerInfo[n][2] * s_TilesetInfo[2];
        GLLibPlayer.s_TilesetLayerInfo[n][5] = s_TilesetLayerInfo[n][3] * s_TilesetInfo[5];
        GLLibPlayer.s_TilesetSprite[n] = aSprite;
        if (n2 > -1) {
            try {
                GLLibPlayer.s_TilesetLayerInfo[n][6] = (s_TilesetInfo[0] & ~s_TilesetInfo[4]) + 1 * s_TilesetInfo[2];
                GLLibPlayer.s_TilesetLayerInfo[n][7] = (s_TilesetInfo[1] & ~s_TilesetInfo[7]) + 1 * s_TilesetInfo[5];
                if (s_TilesetLayerInfo[n][6] - s_TilesetInfo[0] < s_TilesetInfo[2]) {
                    int[] nArray = s_TilesetLayerInfo[n];
                    nArray[6] = nArray[6] + s_TilesetInfo[2];
                }
                if (s_TilesetLayerInfo[n][7] - s_TilesetInfo[1] < s_TilesetInfo[5]) {
                    int[] nArray = s_TilesetLayerInfo[n];
                    nArray[7] = nArray[7] + s_TilesetInfo[5];
                }
                if (n2 == n) {
                    if (s_TilesetLayerImage[n][0] == null || s_TilesetLayerImage[n][0].getWidth() != s_TilesetLayerInfo[n][6] || s_TilesetLayerImage[n][0].getHeight() != s_TilesetLayerInfo[n][7]) {
                        GLLibPlayer.s_TilesetLayerImage[n][0] = Image.createImage((int)s_TilesetLayerInfo[n][6], (int)s_TilesetLayerInfo[n][7]);
                        GLLibPlayer.s_TilesetLayerGraphics[n][0] = s_TilesetLayerImage[n][0].getGraphics();
                    }
                } else {
                    if (s_TilesetLayerImage[n2][0] == null) {
                        new StringBuffer().append("GLLibPlayer.Tileset_LoadLayer. layer ").append(n2).append(" has no circular buffer allocated");
                    }
                    GLLibPlayer.s_TilesetLayerImage[n][0] = s_TilesetLayerImage[n2][0];
                    GLLibPlayer.s_TilesetLayerGraphics[n][0] = s_TilesetLayerGraphics[n2][0];
                }
                GLLibPlayer.setFlag(n, 4, true);
            }
            catch (Exception exception) {
                new StringBuffer().append("GLLibPlayer.Tileset_LoadLayer.pb while ceating circular buffer : ").append(exception.toString());
            }
        }
        GLLibPlayer.s_TilesetLayerInfo[n][8] = -1;
        GLLibPlayer.s_TilesetLayerInfo[n][9] = -1;
        GLLibPlayer.s_TilesetLayerInfo[n][10] = -1;
        GLLibPlayer.s_TilesetLayerInfo[n][11] = -1;
        GLLibPlayer.s_TilesetLayerInfo[n][0] = 1;
        GLLibPlayer.s_TilesetLayerInfo[n][1] = 1;
        GLLibPlayer.s_TilesetLayerInfo[n][12] = 0;
        GLLibPlayer.s_TilesetLayerInfo[n][13] = 0;
        GLLibPlayer.setFlag(n, 1, false);
        GLLibPlayer.setFlag(n, 16, true);
        GLLibPlayer.setFlag(n, 2, false);
        GLLibPlayer.setFlag(n, 32, true);
        GLLibPlayer.setFlag(n, 8, false);
    }

    static void Tileset_Destroy(int n) {
        GLLibPlayer.Tileset_Destroy(n, true);
    }

    private static void Tileset_Destroy(int n, boolean bl) {
        if (!s_bTilesetPlayerInitialized) {
            return;
        }
        GLLibPlayer.s_TilesetLayerInfo[n] = new int[15];
        if (bl) {
            GLLibPlayer.s_TilesetLayerImage[n] = new Image[1];
            GLLibPlayer.s_TilesetLayerGraphics[n] = new Graphics[1];
        }
        GLLibPlayer.s_TilesetLayerData[n] = new byte[2][];
        GLLibPlayer.s_TilesetSprite[n] = null;
    }

    /*
     * WARNING - void declaration
     */
    static void Tileset_Draw(Graphics graphics, int n, int n2, int n3) {
        block36: {
            int n4;
            int n5;
            int n6;
            int n7;
            block35: {
                void var21_39;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                int[] nArray;
                block42: {
                    block40: {
                        block41: {
                            block39: {
                                block37: {
                                    block38: {
                                        if (!s_bTilesetPlayerInitialized) {
                                            return;
                                        }
                                        n7 = s_TilesetInfo[0];
                                        n6 = s_TilesetInfo[1];
                                        if (n3 == -1) {
                                            for (int i = 0; i < s_TilesetMaxLayerCount; ++i) {
                                                if (i == s_TilesetAlphaLayer) continue;
                                                GLLibPlayer.Tileset_Draw(graphics, n, n2, i);
                                            }
                                            return;
                                        }
                                        nArray = s_TilesetLayerInfo[n3];
                                        if (nArray[0] != 1 || nArray[1] != 1) {
                                            return;
                                        }
                                        GLLib.Profiler_BeginNamedEvent("Tileset_Draw");
                                        n5 = nArray[12];
                                        n4 = nArray[13];
                                        if (!GLLibPlayer.isFlag(n3, 4)) break block35;
                                        n13 = 0;
                                        n12 = 0;
                                        n11 = 0;
                                        n10 = 0;
                                        if (GLLib.IsClipValid(graphics)) {
                                            n13 = GLLib.GetClipX(graphics);
                                            n12 = GLLib.GetClipY(graphics);
                                            n11 = GLLib.GetClipWidth(graphics);
                                            n10 = GLLib.GetClipHeight(graphics);
                                        }
                                        n9 = n5 >> s_TilesetInfo[3];
                                        int n14 = n4 >> s_TilesetInfo[6];
                                        int n15 = n5 + s_TilesetInfo[0] >> s_TilesetInfo[3];
                                        int n16 = n4 + s_TilesetInfo[1] >> s_TilesetInfo[6];
                                        int n17 = 0;
                                        int n18 = 0;
                                        if (nArray[9] != n14 || nArray[11] != n16) {
                                            if (nArray[9] < n14 || nArray[11] < n16) {
                                                if (nArray[11] < n14) {
                                                    n17 = n14;
                                                    n18 = n16;
                                                } else {
                                                    n17 = nArray[11] + 1;
                                                    n18 = n16;
                                                }
                                            } else if (nArray[9] > n16) {
                                                n17 = n14;
                                                n18 = n16;
                                            } else {
                                                n17 = n14;
                                                n18 = nArray[9] - 1;
                                            }
                                        }
                                        if (nArray[8] != n9 || nArray[10] != n15) {
                                            void var21_32;
                                            int n19;
                                            int n20;
                                            if (nArray[8] < n9 || nArray[10] < n15) {
                                                if (nArray[10] < n9) {
                                                    n20 = n9;
                                                    n19 = n15;
                                                } else {
                                                    n20 = nArray[10] + 1;
                                                    n19 = n15;
                                                }
                                            } else if (nArray[8] > n15) {
                                                n20 = n9;
                                                n19 = n15;
                                            } else {
                                                n20 = n9;
                                                n19 = nArray[8] - 1;
                                            }
                                            int bl = n16 - n14;
                                            n8 = n14;
                                            if (nArray[9] != n14 || nArray[11] != n16) {
                                                if (nArray[9] < n14 || nArray[11] < n16) {
                                                    int n21 = bl - (n18 - n17 + 1);
                                                } else {
                                                    int n22 = bl - (n18 - n17 + 1);
                                                    n8 += n18 - n17 + 1;
                                                }
                                            }
                                            if (var21_32 >= 0) {
                                                GLLibPlayer.Tileset_UpdateBuffer(s_TilesetLayerGraphics[n3][0], n3, n20, n8, n19 - n20, (int)var21_32, 0, 0);
                                            }
                                            nArray[8] = n9;
                                            nArray[10] = n15;
                                        }
                                        if (nArray[9] != n14 || nArray[11] != n16) {
                                            GLLibPlayer.Tileset_UpdateBuffer(s_TilesetLayerGraphics[n3][0], n3, n9, n17, n15 - n9, n18 - n17, 0, 0);
                                            nArray[9] = n14;
                                            nArray[11] = n16;
                                        }
                                        if (graphics == null) break block36;
                                        boolean bl = false;
                                        if (GLLibPlayer.isFlag(n3, 17)) break block37;
                                        if (n5 >= 0) break block38;
                                        n -= n5;
                                        n5 = 0;
                                        boolean bl2 = true;
                                        break block39;
                                    }
                                    if (n5 <= nArray[4] - n7) break block39;
                                    n -= n5 - (nArray[4] - n7);
                                    n5 = nArray[4] - n7;
                                    boolean bl = true;
                                    break block39;
                                }
                                while (n5 < 0) {
                                    n5 += nArray[6];
                                }
                            }
                            if (GLLibPlayer.isFlag(n3, 34)) break block40;
                            if (n4 >= 0) break block41;
                            n2 -= n4;
                            n4 = 0;
                            boolean bl = true;
                            break block42;
                        }
                        if (n4 <= nArray[5] - n6) break block42;
                        n2 -= n4 - (nArray[5] - n6);
                        n4 = nArray[5] - n6;
                        boolean bl = true;
                        break block42;
                    }
                    while (n4 < 0) {
                        n4 += nArray[7];
                    }
                }
                n8 = n5 % nArray[6];
                n9 = n4 % nArray[7];
                n5 = (n5 + n7) % nArray[6];
                int n21 = (n4 + n6) % nArray[7];
                GLLib.SetClip(graphics, n13, n12, n11, n10);
                if (n5 > n8) {
                    if (n21 > n9) {
                        GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, n9, n7, n6, n + 0, n2 + 0, (boolean)var21_39);
                    } else {
                        GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, n9, n7, n6 - n21, n + 0, n2 + 0, (boolean)var21_39);
                        GLLib.SetClip(graphics, n13, n12, n11, n10);
                        GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, 0, n7, n21, n + 0, n6 - n21 + n2, (boolean)var21_39);
                    }
                } else if (n21 > n9) {
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, n9, n7 - n5, n6, n + 0, n2 + 0, (boolean)var21_39);
                    GLLib.SetClip(graphics, n13, n12, n11, n10);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, 0, n9, n5, n6, n7 - n5 + n, n2 + 0, (boolean)var21_39);
                } else {
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, n9, n7 - n5, n6 - n21, n + 0, n2 + 0, (boolean)var21_39);
                    GLLib.SetClip(graphics, n13, n12, n11, n10);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n8, 0, n7 - n5, n21, n + 0, n6 - n21 + n2, (boolean)var21_39);
                    GLLib.SetClip(graphics, n13, n12, n11, n10);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, 0, n9, n5, n6 - n21, n7 - n5 + n, n2 + 0, (boolean)var21_39);
                    GLLib.SetClip(graphics, n13, n12, n11, n10);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, 0, 0, n5, n21, n7 - n5 + n, n6 - n21 + n2, (boolean)var21_39);
                }
                GLLib.SetClip(graphics, n13, n12, n11, n10);
                break block36;
            }
            if (graphics != null) {
                int n22;
                int n23 = n5 >> s_TilesetInfo[3];
                int n24 = n4 >> s_TilesetInfo[6];
                int n25 = n7 >> s_TilesetInfo[3];
                if (n25 << s_TilesetInfo[3] < n7) {
                    ++n25;
                }
                if ((n22 = n6 >> s_TilesetInfo[6]) << s_TilesetInfo[6] < n6) {
                    ++n22;
                }
                int n26 = (n23 << s_TilesetInfo[3]) - n5;
                int n27 = (n24 << s_TilesetInfo[6]) - n4;
                GLLibPlayer.Tileset_UpdateBuffer(graphics, n3, n23, n24, n25, n22, n26 + n, n27 + n2);
            }
        }
        GLLib.Profiler_EndNamedEvent();
    }

    private static void Tileset_Draw2Screen(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        if (bl) {
            if (n6 > GLLib.s_screenWidth || n7 > GLLib.s_screenHeight || n6 + n4 < 0 || n7 + n5 < 0) {
                return;
            }
            GLLib.ClipRect(graphics, n6, n7, n4, n5);
            GLLib.ClipRect(graphics, 0, 0, GLLib.s_screenWidth, GLLib.s_screenHeight);
            graphics.drawImage(s_TilesetLayerImage[n][0], n6 - n2, n7 - n3, 0);
            return;
        }
        GLLib.ClipRect(graphics, n6, n7, n4, n5);
        graphics.drawImage(s_TilesetLayerImage[n][0], n6 - n2, n7 - n3, 0);
    }

    private static void Tileset_UpdateBuffer(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl = GLLibPlayer.isFlag(n, 4);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        boolean bl2 = GLLibPlayer.isFlag(n, 1);
        boolean bl3 = GLLibPlayer.isFlag(n, 2);
        int n12 = s_TilesetLayerInfo[n][2];
        int n13 = s_TilesetLayerInfo[n][3];
        byte[] byArray = s_TilesetLayerData[n][0];
        byte[] byArray2 = s_TilesetLayerData[n][1];
        int n14 = s_TilesetInfo[2];
        int n15 = s_TilesetInfo[5];
        n8 = GLLib.GetClipX(graphics);
        n9 = GLLib.GetClipY(graphics);
        n10 = GLLib.GetClipWidth(graphics);
        n11 = GLLib.GetClipHeight(graphics);
        if (bl) {
            n6 = (n2 << s_TilesetInfo[3]) % s_TilesetLayerInfo[n][6] + n6;
            n7 = (n3 << s_TilesetInfo[6]) % s_TilesetLayerInfo[n][7] + n7;
            if (n6 < 0) {
                n6 += s_TilesetLayerInfo[n][6];
            }
            if (n7 < 0) {
                n7 += s_TilesetLayerInfo[n][7];
            }
        }
        if (bl2) {
            while (n2 < 0) {
                n2 += n12;
            }
            while (n2 >= n12) {
                n2 -= n12;
            }
        } else if (!GLLibPlayer.isFlag(n, 16)) {
            if (n2 < 0) {
                n6 -= n2 * n14;
                n4 += n2;
                n2 = 0;
                if (bl && n6 >= s_TilesetLayerInfo[n][6]) {
                    n6 = 0;
                }
            }
            if (n2 + n4 >= n12) {
                n4 = n12 - n2 - 1;
            }
            if (n4 < 0) {
                return;
            }
        }
        if (bl3) {
            while (n3 < 0) {
                n3 += n13;
            }
            while (n3 >= n13) {
                n3 -= n13;
            }
        } else if (!GLLibPlayer.isFlag(n, 32)) {
            if (n3 < 0) {
                n7 -= n3 * n15;
                n5 += n3;
                n3 = 0;
                if (bl && n7 >= s_TilesetLayerInfo[n][7]) {
                    n7 = 0;
                }
            }
            if (n3 + n5 >= n13) {
                n5 = n13 - n3 - 1;
            }
            if (n5 < 0) {
                return;
            }
        }
        int n16 = n7;
        while (n5-- >= 0) {
            n7 = n6;
            int n17 = n4;
            int n18 = n2;
            while (n17-- >= 0) {
                int n19 = n18 + n3 * n12;
                if (n19 << 1 < byArray.length) {
                    int n20;
                    int n21;
                    int n22 = GLLib.Mem_GetShort(byArray, n19 << 1) & 0xFFFF;
                    int n23 = n21 = n22 == 65535 ? 1 : 0;
                    if (GLLibPlayer.isFlag(n, 128)) {
                        n20 = graphics.getColor();
                        graphics.setColor(0);
                        graphics.fillRect(n7, n16, n14, n15);
                        graphics.setColor(n20);
                    }
                    if (n21 == 0) {
                        n19 = byArray2 == null ? 0 : byArray2[n19] & 0xFF;
                        GLLib.ClipRect(graphics, n7, n16, n14, n15);
                        if (s_TilesetSprite[n].GetFrameCount() == 0) {
                            s_TilesetSprite[n].PaintModule(graphics, n22, n7, n16, n19);
                        } else {
                            n20 = n7;
                            n21 = n16;
                            if ((n19 & 1) != 0) {
                                n20 += n14;
                            }
                            if ((n19 & 2) != 0) {
                                n21 += n15;
                            }
                            int n24 = n19;
                            int n25 = n21;
                            n21 = n22;
                            Graphics graphics2 = graphics;
                            ASprite aSprite = s_TilesetSprite[n];
                            aSprite.PaintFrame(graphics2, n21, n20, n25, n24, 0, 0);
                        }
                        GLLib.SetClip(graphics, n8, n9, n10, n11);
                    }
                }
                n7 += n14;
                if (++n18 >= n12) {
                    if (!bl2) break;
                    n18 = 0;
                }
                if (!bl || n7 < s_TilesetLayerInfo[n][6]) continue;
                n7 = 0;
            }
            n16 += n15;
            if (++n3 >= n13) {
                if (!bl3) break;
                n3 = 0;
            }
            if (!bl || n16 < s_TilesetLayerInfo[n][7]) continue;
            n16 = 0;
        }
    }

    private static final int Tileset_GetTranslatedOriginY(int n, int n2) {
        if (GLLibPlayer.isFlag(n, 8)) {
            return s_TilesetLayerInfo[n][5] - s_TilesetInfo[1] - n2;
        }
        return n2;
    }

    static final void Tileset_SetCamera(int n, int n2, int n3) {
        if (!s_bTilesetPlayerInitialized) {
            return;
        }
        if (n < 0 || n >= s_TilesetMaxLayerCount) {
            new StringBuffer().append("Tileset_SetCamera: nLayer invalid : ").append(n);
            return;
        }
        if (s_TilesetLayerInfo[n][0] != 1 || s_TilesetLayerInfo[n][1] != 1) {
            return;
        }
        GLLibPlayer.s_TilesetLayerInfo[n][12] = n2;
        GLLibPlayer.s_TilesetLayerInfo[n][13] = GLLibPlayer.Tileset_GetTranslatedOriginY(n, n3);
        if (GLLibPlayer.isFlag(n, 16)) {
            if (s_TilesetLayerInfo[n][12] < 0) {
                GLLibPlayer.s_TilesetLayerInfo[n][12] = 0;
            } else if (s_TilesetLayerInfo[n][12] + s_TilesetInfo[0] > s_TilesetLayerInfo[n][4]) {
                GLLibPlayer.s_TilesetLayerInfo[n][12] = s_TilesetLayerInfo[n][4] - s_TilesetInfo[0];
            }
        }
        if (GLLibPlayer.isFlag(n, 32)) {
            if (s_TilesetLayerInfo[n][13] < 0) {
                GLLibPlayer.s_TilesetLayerInfo[n][13] = 0;
                return;
            }
            if (s_TilesetLayerInfo[n][13] + s_TilesetInfo[1] > s_TilesetLayerInfo[n][5]) {
                GLLibPlayer.s_TilesetLayerInfo[n][13] = s_TilesetLayerInfo[n][5] - s_TilesetInfo[1];
            }
        }
    }

    static final int Tileset_GetCameraX(int n) {
        if (!s_bTilesetPlayerInitialized) {
            return -1;
        }
        if (s_TilesetMaxLayerCount <= 0) {
            new StringBuffer().append("Tileset_GetCamera: nLayer invalid : ").append(0);
            return -1;
        }
        if (s_TilesetLayerInfo[0][0] != 1 || s_TilesetLayerInfo[0][1] != 1) {
            return -1;
        }
        return s_TilesetLayerInfo[0][12];
    }

    static final int Tileset_GetCameraY(int n) {
        if (!s_bTilesetPlayerInitialized) {
            return -1;
        }
        if (s_TilesetMaxLayerCount <= 0) {
            new StringBuffer().append("Tileset_GetCamera: nLayer invalid : ").append(0);
            return -1;
        }
        if (s_TilesetLayerInfo[0][0] != 1 || s_TilesetLayerInfo[0][1] != 1) {
            return -1;
        }
        if (GLLibPlayer.isFlag(0, 8)) {
            return s_TilesetLayerInfo[0][5] - s_TilesetInfo[1] - s_TilesetLayerInfo[0][13];
        }
        return s_TilesetLayerInfo[0][13];
    }

    static final int Tileset_GetLayerWidth(int n) {
        if (!s_bTilesetPlayerInitialized) {
            return -1;
        }
        if (s_TilesetMaxLayerCount <= 0) {
            new StringBuffer().append("Tileset_GetLayerWidth: nLayer invalid : ").append(0);
            return -1;
        }
        if (s_TilesetLayerInfo[0][0] != 1 || s_TilesetLayerInfo[0][1] != 1) {
            return -1;
        }
        return s_TilesetLayerInfo[0][4];
    }

    static final int Tileset_GetLayerHeight(int n) {
        if (!s_bTilesetPlayerInitialized) {
            return -1;
        }
        if (s_TilesetMaxLayerCount <= 0) {
            new StringBuffer().append("Tileset_GetLayerHeight: nLayer invalid : ").append(0);
            return -1;
        }
        if (s_TilesetLayerInfo[0][0] != 1 || s_TilesetLayerInfo[0][1] != 1) {
            return -1;
        }
        return s_TilesetLayerInfo[0][5];
    }

    static final int Tileset_GetLayerTileCountWidth(int n) {
        if (!s_bTilesetPlayerInitialized) {
            return -1;
        }
        if (n < 0 || n >= s_TilesetMaxLayerCount) {
            new StringBuffer().append("Tileset_GetLayerTileCountWidth: nLayer invalid : ").append(n);
            return -1;
        }
        if (s_TilesetLayerInfo[n][0] != 1 || s_TilesetLayerInfo[n][1] != 1) {
            return -1;
        }
        return s_TilesetLayerInfo[n][2];
    }

    static final int Tileset_GetLayerTileCountHeight(int n) {
        if (!s_bTilesetPlayerInitialized) {
            return -1;
        }
        if (n < 0 || n >= s_TilesetMaxLayerCount) {
            new StringBuffer().append("Tileset_GetLayerTileCountHeight: nLayer invalid : ").append(n);
            return -1;
        }
        if (s_TilesetLayerInfo[n][0] != 1 || s_TilesetLayerInfo[n][1] != 1) {
            return -1;
        }
        return s_TilesetLayerInfo[n][3];
    }

    static final int Tileset_GetTile(int n, int n2, int n3) {
        n3 = GLLibPlayer.Tileset_GetTranslatedOriginY(n, n3);
        if (!s_bTilesetPlayerInitialized) {
            return -1;
        }
        if (n < 0 || n >= s_TilesetMaxLayerCount) {
            new StringBuffer().append("Tileset_GetTile: nLayer invalid : ").append(n);
            return -1;
        }
        if (s_TilesetLayerInfo[n][0] != 1 || s_TilesetLayerInfo[n][1] != 1) {
            return -1;
        }
        if (n2 < 0 || n2 > s_TilesetLayerInfo[n][2]) {
            new StringBuffer().append("Tileset_GetTile: x value out of bound [").append(n2).append("]  0 <= x < ").append(s_TilesetLayerInfo[n][2]);
            return -1;
        }
        if (n3 < 0 || n3 > s_TilesetLayerInfo[n][3]) {
            new StringBuffer().append("Tileset_GetTile: y value out of bound [").append(n3).append("]  0 <= y < ").append(s_TilesetLayerInfo[n][3]);
            return -1;
        }
        return GLLib.Mem_GetShort(s_TilesetLayerData[n][0], n3 * s_TilesetLayerInfo[n][2] + n2 << 1) & 0xFFFF;
    }
}

